// popup.js
document.addEventListener("DOMContentLoaded", async () => {
    const toggleSwitch = document.getElementById("toggle-switch");
    const { enabled } = await chrome.storage.sync.get("enabled");
    toggleSwitch.checked = enabled !== false;

    toggleSwitch.addEventListener("change", async (event) => {
        const enabled = event.target.checked;
        await chrome.storage.sync.set({ enabled });
    });
});
